# Generated Python Strategy for: PlayerB (meta)
# Run Index: 3
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerB_DeepSeek_V3_MetaAgent_Run3_Iter1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Heuristic 1: Check for simple strategies (always cooperate/defect)
    if "always_cooperate" in opponent_program_code.lower() or "return 'c'" in opponent_program_code.lower():
        return "C"
    if "always_defect" in opponent_program_code.lower() or "return 'd'" in opponent_program_code.lower():
        return "D"
    
    # Heuristic 2: Check for Tit-for-Tat-like strategies
    tit_for_tat_keywords = ["opp_history[-1]", "opp_history[len(opp_history)-1]", "return opp_history[-1]"]
    if any(keyword in opponent_program_code for keyword in tit_for_tat_keywords):
        if not opp_history:
            return "C"
        return opp_history[-1]
    
    # Heuristic 3: Check for code similarity (e.g., if opponent checks for keywords like we do)
    similarity_keywords = ["opponent_program_code", "heuristic", "cooperate", "defect", "history"]
    similar_count = sum(keyword in opponent_program_code.lower() for keyword in similarity_keywords)
    if similar_count >= 3:
        return "C"
    
    # Heuristic 4: Check for random or complex strategies
    if "random.choice" in opponent_program_code or "import random" in opponent_program_code:
        return "D"  # Be cautious against random strategies
    
    # Heuristic 5: Code length (short code might be simple, long code might be complex)
    if len(opponent_program_code.splitlines()) <= 5:
        return "C"  # Cooperate with simple strategies
    else:
        return "D"  # Defect against complex strategies (might be exploitative)
    
    # Fallback: Tit-for-Tat if no heuristic matches
    if not opp_history:
        return "C"
    return opp_history[-1]